function [box zero range eigvec]=make_box3(points,num_of_points)

%OK

N=size(points,1);
dim=size(points,2);

meanval=mean(points,1);
medianval=2*(median(abs(points-ones(N,1)*meanval),1));
eigvec=eye(3);

%range=1.5*sqrt(diag(eigval)/N);
%pom=points*eigvec/2;
%range=min((max(pom)-min(pom))',range);
%range=(max(points)-min(points))';
range=medianval';


box=zeros(N,dim);
pointer=-range;
pointer(3)=(min(points))*[0;0;1];
step=2*range/(num_of_points-1);
jump=[1 num_of_points num_of_points^2];
for i=1:N
    for k=1:dim
        box(i,k)=pointer(k)+step(k)*mod(floor((i-1)/jump(k)),num_of_points);
    end
end  

box=box+ones(N,1)*(meanval.*[1 1 0]);
range=ones(3,1)./(2*range);
zero=box(1,:);

plot3(points(:,1),points(:,2),points(:,3),'r.');
hold on;
plot3(box(:,1),box(:,2),box(:,3),'g.');
hold off;

%plot3(box(1,1),box(1,2),box(1,3),'r+');
%plot3(box(2,1),box(2,2),box(2,3),'b+');
%plot3(box(3,1),box(3,2),box(3,3),'b+');

%plot3(box(64,1),box(64,2),box(64,3),'g+');
%plot3(box(4,1),box(4,2),box(4,3),'b+');
end